package nl.umcg.deelenp.annotateintersectionoverview.annotations.sources;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.TreeMap;
import nl.umcg.deelenp.annotateintersectionoverview.annotations.AnnotationProperty;
import nl.umcg.deelenp.annotateintersectionoverview.annotations.AnnotationSourcePosition;
import nl.umcg.deelenp.annotateintersectionoverview.annotations.properties.StringProperty;
import nl.umcg.deelenp.metaqtloutput.EQtl;
import nl.umcg.deelenp.metaqtloutput.MetaQtlOutput;

/**
 *
 * @author PatrickDeelen
 */
public class EQtlAnnotations implements AnnotationSourcePosition {

    private TreeMap<String, TreeMap<Integer, ArrayList<EQtl>>> eQtls;
    private static final String[] ANNOTATION_HEADERS = {"eQTL genes"};
    private static final int numberOfAnnotationProperties = 1;

    public EQtlAnnotations(String metaQtlOutputFile) throws FileNotFoundException, IOException, Exception {
         MetaQtlOutput metaQtlOutput = new MetaQtlOutput(metaQtlOutputFile);
         eQtls = metaQtlOutput.getChromosomePositionEQtlMap();
    }

    public String[] getAnnotationHeaders() {
        return ANNOTATION_HEADERS;
    }

    public AnnotationProperty[] getAnnotationForPosition(String chromosome, int position) {

        AnnotationProperty[] annotations = new AnnotationProperty[numberOfAnnotationProperties];
       
        if(eQtls.containsKey(chromosome)){
            TreeMap<Integer, ArrayList<EQtl>> chromosomeEQtls = eQtls.get(chromosome);
            if(chromosomeEQtls.containsKey(position)){
                ArrayList<EQtl> positionEQtls = chromosomeEQtls.get(position);
                StringBuilder genes = new StringBuilder();
                boolean notFirst = false;
                
                for(EQtl eQtl : positionEQtls){
                    if(notFirst){
                        genes.append("-"); 
                    }
                    notFirst = true;
                    if(!eQtl.getHgncName().equals("-")){
                        genes.append(eQtl.getHgncName());
                    } else {
                        genes.append(eQtl.getProbeName());
                    }
                    
                }
                annotations[0] = new StringProperty(genes.toString());
            }

        }

        return annotations;

    }

    public int getNumberOfAnnotationProperties() {
        return numberOfAnnotationProperties;
    }

}