package nl.umcg.deelenp.annotateintersectionoverview.writers;

/**
 *
 * @author PatrickDeelen
 */
public class AnnotationWriterLineInfo {

    private String chromosome;
    private int position;
    private StringBuilder line;
    private String snpId;

    public AnnotationWriterLineInfo(String chromosome, int position, StringBuilder line) {
        this.chromosome = chromosome;
        this.position = position;
        this.line = line;
        this.snpId = null;
    }

    public AnnotationWriterLineInfo(String chromosome, int position, StringBuilder line, String snpId) {
        this.chromosome = chromosome;
        this.position = position;
        this.line = line;
        this.snpId = snpId;
    }

    public AnnotationWriterLineInfo(StringBuilder line, String snpId) {
        this.line = line;
        this.snpId = snpId;
        this.chromosome = null;
        this.position = -1;
    }

    public String getChromosome() {
        return chromosome;
    }

    public StringBuilder getLine() {
        return line;
    }

    public int getPosition() {
        return position;
    }

    public void append(String string){
        line.append(string);
    }

    public String getSnpId() {
        return snpId;
    }
    
}
