package nl.umcg.deelenp.annotateintersectionoverview.writers;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.regex.Pattern;
import nl.umcg.deelenp.annotateintersectionoverview.ToolBox;
import nl.umcg.deelenp.annotateintersectionoverview.annotations.AnnotationProperty;
import nl.umcg.deelenp.annotateintersectionoverview.annotations.AnnotationSource;
import nl.umcg.deelenp.annotateintersectionoverview.annotations.AnnotationSourcePosition;

/**
 *
 * @author PatrickDeelen
 */
public class SeparatedTextAnnotationWriter implements AnnotationWriter{

    private ArrayList<AnnotationWriterLineInfo> lines;
    private StringBuilder headerString;
    private boolean header;
    private String separator;
    private Pattern separatorPattern;
    private boolean closed = false;
    private String targetFilePath;

    public SeparatedTextAnnotationWriter(String sourceFilePath, String targetFilePath, boolean header, String separator, int chromosomeColumn, int positionColumn, int snpColumn) throws FileNotFoundException, Exception {

        if(sourceFilePath.equals(targetFilePath)){
            throw new Exception("Source and target file path for annotation are identical");
        }

        this.header = header;
        this.separator = separator;
        this.targetFilePath = targetFilePath;
        lines = new ArrayList<AnnotationWriterLineInfo>();
        separatorPattern = Pattern.compile(separator);

        BufferedReader reader = new BufferedReader(new FileReader(sourceFilePath));

        if(header){
            headerString = new StringBuilder(reader.readLine());
        }

        String line;
        while( (line = reader.readLine()) != null ){
           String[] lineElements = separatorPattern.split(line);
           String chromosome = ToolBox.trimChr(lineElements[chromosomeColumn]);
           int position = Integer.parseInt(lineElements[positionColumn]);
           lines.add(new AnnotationWriterLineInfo(chromosome, position, new StringBuilder(line)));
        }

    }

    public void addAnnotations(ArrayList<AnnotationSource> annotations) throws Exception {

        if(closed){
            throw new Exception("Writer already closed");
        }

        for(AnnotationSource annotation : annotations){

            if(header){
                for(String annotationHeader : annotation.getAnnotationHeaders()){
                    headerString.append(separator);
                    headerString.append(annotationHeader);
                }
            }

        }

        for(AnnotationWriterLineInfo line : lines){

            String chromosome = line.getChromosome();
            int position = line.getPosition();
            
            for(AnnotationSource annotation : annotations){

                AnnotationProperty[] properties;
                if(annotation.getClass() == AnnotationSourcePosition.class){
                    properties = ((AnnotationSourcePosition)annotation).getAnnotationForPosition(chromosome, position);
                } else {
                    continue;
                }

                for(AnnotationProperty property : properties){

                    line.append(separator);

                    if(property != null){
                        line.append(property.getProperty());
                    }

                }
            }

        }

    }

    public void close() throws Exception {

        closed = true;

        BufferedWriter writer = new BufferedWriter(new FileWriter(targetFilePath));

        if(header){
            writer.append(headerString);
            writer.append('\n');
        }

        for(AnnotationWriterLineInfo line : lines){
            writer.append(line.getLine());
            writer.append('\n');
        }

    }

}

